/*
 *  Document   : features.js
 *  Author     : pixelcave
 *  Description: Custom javascript code used in Features page
 */

var Features = function() {

    return {
        init: function() {
            /*
             * With Jquery Appear plugin
             */
            $('.circle').each(function(){
                $(this).appear(function() {
                    $(this).addClass('animation-fadeIn360');
                },{accY: -100});
            });

            /*
             * With CountTo (+ help of Jquery Appear plugin), Check out examples and documentation at https://github.com/mhuggins/jquery-countTo
             */
            $('.counter span').each(function(){
                var $this = $(this);

                $this.appear(function() {
                    $this.countTo({
                        speed: 1500,
                        refreshInterval: 25,
                        onComplete: function() {
                            if($this.data('after')) {
                                $this.html($this.html() + $this.data('after'));
                            }
                        }
                    });
                });
            });
        }
    };
}();